require "prefabutil"

local assets=
{
    Asset("ANIM", "anim/emcsolarbooster.zip"),
	--Asset("ANIM", "anim/dust_fx.zip"),
    Asset("SOUND", "sound/forest.fsb"),
}


local function DoIdle(inst)
	if inst.isWorking == false then
		if inst.wasON == true then
			inst.EMClight:Enable(false)
			inst.AnimState:PlayAnimation("off",true)
			inst.wasON = false
		end
		return
	end
	inst.components.EMCglobalbuffer:AddFromGlobal(3000*100/(480*2),-3000)
	if inst.components.EMCglobalbuffer:GetBool(3000*50/(480*2)) then
		local pt = Point(inst.Transform:GetWorldPosition())
		local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, 16, nil, {"NOBLOCK", "player", "FX", "INLIMBO", "DECOR"}) -- or we could include a flag to the search?
		for k, v in pairs(ents) do
			if v ~= inst and v.entity:IsValid() and v.entity:IsVisible() and not v.components.placer and v.parent == nil then
				if v:HasTag("EMCsolar") then
					--print("found EMCsolar")
					v.EMCboosted = true
				end
			end
		end
		if inst.wasON == false then
			inst.EMClight:Enable(true)
			inst.AnimState:PlayAnimation("on",true)
			inst.wasON = true
		end
	else
		if inst.wasON == true then
			inst.EMClight:Enable(false)
			inst.AnimState:PlayAnimation("off",true)
			inst.wasON = false
		end
	end
end

local function StopIdling(inst)
    if inst.idletask then
        inst.idletask:Cancel()
        inst.idletask = nil
    end
end

local function StartIdling(inst)	
	if not inst.idletask then
		inst.idletask = inst:DoPeriodicTask(0.5, DoIdle)
	end
end


local function onhammered(inst, worker)
	--inst.components.lootdropper:DropLoot()
	--inst.components.container:DropEverything()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")	
	inst:Remove()
end

local function onhit(inst, worker)
	--inst.AnimState:PlayAnimation("hit")
	--inst.components.container:DropEverything()
	--inst.AnimState:PushAnimation("closed", false)
	--inst.components.container:Close()
end

local function onbuilt(inst)
	--inst.AnimState:SetBank("pinecone")
	--inst.AnimState:SetBuild("pinecone")
	--inst.AnimState:PlayAnimation("idle_planted")
	--inst.AnimState:PushAnimation("closed", false)
end




local function OnSave(inst, data)
	if inst.isWorking == true then
		data["69"] = "awesome"
	end
end

local function OnLoad(inst, data)
    if data and data["69"] then
		inst.isWorking = true
	end
	
end
		
local function init()
	local fn = function(Sim)
		local inst = CreateEntity()
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		inst.entity:AddSoundEmitter()
		--local minimap = inst.entity:AddMiniMapEntity()
		
		--minimap:SetIcon( "birdcage.png" )


		inst:AddTag("structure")
		inst.AnimState:SetBank("emcsolarbooster")
		inst.AnimState:SetBuild("emcsolarbooster")
		inst.AnimState:PlayAnimation("off",true)
		
		
		inst:AddComponent("inspectable")
		
		--inst:AddComponent("lootdropper")
		inst:AddComponent("workable")
		inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
		inst.components.workable:SetWorkLeft(2)
		inst.components.workable:SetOnFinishCallback(onhammered)
		inst.components.workable:SetOnWorkCallback(onhit) 
		
		inst.isWorking = true
		
		inst:AddComponent("activatable")
		inst.components.activatable.OnActivate = function(inst)
			inst.isWorking = not inst.isWorking
			inst.components.activatable.inactive = true
		end
		inst.components.activatable.inactive = true
		
		inst:ListenForEvent( "onbuilt", onbuilt)
		MakeSnowCovered(inst, .01)
		
		inst.EMClight = inst.entity:AddLight()
		inst.EMClight:SetIntensity(0.7)
		inst.EMClight:SetRadius(8)
		inst.EMClight:SetColour(1,1,1)
		inst.EMClight:Enable(false)
		
		inst:AddComponent("EMCglobalbuffer")
		inst.components.EMCglobalbuffer.maxEMC = 30000
		inst.wasON = false
		StartIdling(inst)
		
		inst.OnSave = OnSave
		inst.OnLoad = OnLoad
	
		return inst
	end
	return fn
end



return	Prefab( "common/prefab/emcsolarbooster", init(), assets),
		MakePlacer("common/prefab/emcsolarbooster_placer", "emcsolarbooster", "emcsolarbooster", "on")


		
		
		